---
title: Make Beautiful Reports with Pandoc
date: 2025-02-05T10:08:09+00:00
draft: false
tags:
  - ubuntu
---
I've found myself needing to make a PDF report from something written in Markdown. Obsidian's built-in PDF Export and Better PDF Export both work fine, but they lack the flexibility - particularly in making a table of contents with page numbers.

After some research, I've come across a theme for Pandoc called Eisvogel, which allows you to export pretty documents from Markdown files.

# Installation
Install Pandoc via [their instructions](https://pandoc.org/installing.html). You'll also need to install TeX Live for generating PDF documents too - on Debian/Ubuntu this is `sudo apt install texlive`.

Then, copy the `eisvogel.tex` from Eisvogel's [latest release](https://github.com/enhuiz/eisvogel/tags) to `~/.pandoc/templates/eisvogel.latex` in your home folder.

# Frontmatter
In order to use all of the features, you need to add some stuff to your frontmatter:
```yaml
---
title: Document Title
subtitle: Subtitle
author: You
lang: en
titlepage: true
toc-own-page: true
---
```
This one specifies to add a title page, and to add a page break after the table of contents. More documentation on frontmatter options [here](https://github.com/enhuiz/eisvogel?tab=readme-ov-file#custom-template-variables).

# The Command
```bash
pandoc -f gfm -t pdf --template eisvogel --listings --toc=true -o output.pdf input.md
```
This generates an `output.pdf` file from the `input.md`, which is a GitHub Flavored Markdown file (hence `-f gfm`). Listings and a table of contents are enabled, and we're using the Eisvogel template.

Here's what it looks like:
![[Pasted Image 20250210233211.png]]
# Change the Font
You can change the font to any installed on your system by using the xelatex engine instead of the standard pdftex one. Install it with `sudo apt install texlive-xetex`, then run the following to generate the file:
```bash
pandoc -f gfm -t pdf --pdf-engine=xelatex --template eisvogel --listings --toc=true -o output.pdf input.md
```

> [!TIP]
> You may need to remove the `lang` attribute from your frontmatter because there seems to be a bug with it.

However, after this you can then set the `mainfont` property to any font on your system:
```yaml
---
title: Document Title
subtitle: Subtitle
author: You
titlepage: true
toc-own-page: true
mainfont: "Inter"
---
```

# Add a Title Page
Place a file named `background.pdf` in the same directory. If you're stuck for a background, try [this example](https://github.com/enhuiz/eisvogel/blob/master/examples/custom-titlepage/background.pdf).

Then, just add this to your frontmatter:
```yaml
---
...
titlepage: true
titlepage-text-color: FFFFFF
titlepage-rule-color: "360049"
titlepage-rule-height: 0
titlepage-background: "background.pdf"
---
```
